//=============================================================================
// UT99 Extension Pack V1.0
// - Basic Edition -
// class by Shadow
// DynamicProjector
//-----------------
// Updates:
// - 11.5. 07 - added fixed attach support
// - 4.10. 07 - attach control variable
//=============================================================================
class DynamicProjector expands Projector;

var() enum ESizeModifier
{
	Scale_Constant,
	Scale_Shrink,
	Scale_Grow,
	Scale_DependsOnDistance
}SizeModifier;
var() bool bReverse,bUVScaling,bMsg;
var() enum EBlinkType
{
	BL_None,
	BL_FastFlicker,
	BL_Flicker,
	BL_Blink
}BlinkType;

var() float ProjShrinktime,ProjGrowtime,ProjMinSize,ProjMaxSize,UScale,VScale,Blinkrate;
var() int DistanceFactor;
var() bool bAdaptRot;

var bool bblink,battach;
var actor master;
var vector offset;
var rotator dir;

final function DynamicProject(float t)
{
	class'XTMainUtil'.static.dynamicproject(self,t);
}

function PreBeginPlay()
{
	super.prebeginplay();
	if(blinktype==bl_blink)settimer(blinkrate,true);
}

//update projection each updatetick:
simulated function Tick(float deltatime)
{	
	super.tick(deltatime);
	if(class'xtmutator'.default.bprojectors)dynamicproject(deltatime);
	if (battach)
    {
	   if (master!=none)
	   {
	      class'XTPhysicUtil'.static.attach(self,master.location,dir,vect(0,0,0),32); //attach support
       }
    }
}
simulated function Timer(){bblink=!bblink;}

defaultproperties
{
     bStatic=False
     bNoDelete=False
     bStasis=True
     Texture=Texture'UT99ExtensionPack.EdStuff.S_Projector2'
     bGameRelevant=False
     bTravel=True
     bMovable=True
}
